local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();

-- common stuff for everyone to love!!
local genericGainFocusCmd = cmd(finishtweening;visible,true);
local genericLoseFocusCmd = cmd(visible,false);

local t = Def.ActorFrame{
	Name="Item"..iIndex;
	GainFocusCommand=genericGainFocusCmd;
	LoseFocusCommand=genericLoseFocusCmd;
	
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="OptionName"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName);
		InitCommand=cmd(shadowlength,1;diffuse,color("#FFFFFF"));
		OnCommand=cmd(y,(SCREEN_CENTER_Y*0.8)-48);
	};
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="OptionInfo"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName.."Desc");
		InitCommand=cmd(shadowlength,0;zoom,0.6;diffuse,color("#000000"));
		OnCommand=cmd(y,SCREEN_CENTER_Y*0.8);
	};
};

-- option-specific junk
if(sName == "Normal") then
	t[#t+1] = Def.ActorFrame{
		Name="NormalPreview";
		GainFocusCommand=genericGainFocusCmd;
		LoseFocusCommand=genericLoseFocusCmd;
		
		OffFocusedCommand=function(self)
			SetSSMusicOption("Normal");
		end;
		
		Def.OptionIconRow {
			Name="OptionIconRowP1";
			InitCommand=cmd(x,-188;y,-64;set,PLAYER_1);
			OnCommand=cmd(diffusealpha,0;linear,0.2;diffusealpha,1);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
	};
	
elseif(sName == "Custom") then
	t[#t+1] = Def.ActorFrame{
		Name="CustomPreview";
		GainFocusCommand=genericGainFocusCmd;
		LoseFocusCommand=genericLoseFocusCmd;
		
		OffFocusedCommand=function(self)
			SetSSMusicOption("Custom");
		end;
	};
	
	local text = {
		"2x",
		"Overhead",
		"Delta",
		"Dizzy"
	};
	
	for i=1,6 do
		if i < 5 then
			t[#t+1] = Def.ActorFrame{
				InitCommand=cmd(x,(-164)+(i*47)-1);
				
				LoadActor("_optionicon")..{
					InitCommand=cmd(diffuse,PlayerColor(PLAYER_1);y,-64;diffusealpha,0.8);
				};
				LoadFont("_frutiger lt std 55 roman 24px")..{
					Text=text[i];
					InitCommand=cmd(y,-64;zoom,0.5;diffuse,color("#FFFFFF");shadowlength,1;maxwidth,90);
				};
			};
		else
			t[#t+1] = Def.ActorFrame{
				InitCommand=cmd(x,(-164)+(i*47)-1;y,-64;diffusealpha,0.8);
				LoadActor("_optionicon");
			};
		end
	end;
	
end;

return t;